// API session management and request handling
/* global sc */

function moduleFunction(config) {
  // Initialize $$ with provided config or default
  let $$ = config || require('./debug')({ debug: 'cache', path: module.id });
  
  let json = require('client/json');

  /**
   * URL encodes parameters object
   * 
   * @param {Object} params - Parameters to encode
   * @returns {string} - URL encoded string
   */
  function urlEncode(params) {
    return Object.entries(params)
      .map(function(entry) {
        return encodeURIComponent(entry[0]) + '=' + encodeURIComponent(entry[1]);
      })
      .join('&');
  }

  /**
   * Session constructor
   * 
   * @param {Object} parms - Session parameters
   * @returns {Session} - Session instance
   */
  function Session(parms) {
    // TODO: get credentials from metadb
    //       create api user on installation
    //       store credentials in metadb
    //       get sessionId from current session (filingassistant/service)
    this._parms = Object.assign(
      {
        server: 'http://localhost',
        username: 'api',
        password: 'agorum',
      },
      parms || {}
    );
    this._sessionId = null;
    return this;
  }

  Session.prototype.login = function() {
    let service = json(this._parms.server, {
      accept: 'application/json',
      type: 'application/x-www-form-urlencoded',
    });
    let response = service('/api/rest/session').post(
      urlEncode({
        username: this._parms.username,
        password: this._parms.password,
      })
    );
    $$.debug('login', response);
    this._sessionId = response.sessionId;
    return this;
  };

  Session.prototype.logout = function() {
    let service = json(this._parms.server, {
      accept: 'application/json',
    });
    let response = service('/api/rest/session').delete({ sessionId: this._sessionId });
    $$.debug('logout', response);
    return response;
  };

  Session.prototype.get = function(service, _parms) {
    let request = json(this._parms.server, {
      accept: 'application/json',
    });
    let parms = Object.assign(
      {
        sessionId: this._sessionId,
      },
      _parms
    );
    let response = request(service).get(parms);
    $$.debug('get', service, response);
    return response;
  };

  Session.prototype.post = function(service, _parms) {
    let request = json(this._parms.server, {
      accept: 'application/json',
      type: 'application/x-www-form-urlencoded',
    });
    let parms = Object.assign(
      {
        sessionId: this._sessionId,
      },
      _parms
    );
    let response = request(service).post(urlEncode(parms));
    $$.debug('post', service, response);
    return response;
  };

  // Return the module functions and constructors
  return {
    urlEncode: urlEncode,
    Session: Session
  };
}

// Initialize $$ when the module is required without parameters
let moduleExports = moduleFunction();

// Export the module function and its methods
module.exports = Object.assign(moduleFunction, moduleExports);
